exports.validateMaximumOfTenItems = async (event) => {
  var cart = event.resource.obj;
  var itemsTotal = cart.lineItems.reduce( (acc, curr) => {
    return acc + curr.quantity;
  }, 0);

  if (itemsTotal <= 10) {
    return { 
      actions: [],
      responseType: "UpdateRequest"
    }
  }
  else {
    return {
      responseType: "FailedValidation",
      errors : [{
        code: "InvalidInput",
        message: "You can not put more than 10 items into the cart."
      }]
    }
  }
};